<xsl:stylesheet
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  version='1.0'>

  <xsl:template match="revhistory" mode="titlepage.mode">
  </xsl:template>
  <xsl:template match="revhistory">
  </xsl:template>

<xsl:key name="refname" match="refnamediv" use="refname" />

  <xsl:template match="refnamediv">
    <div class="{name(.)}">
      <xsl:call-template name="anchor" />
      
      <xsl:choose>
        <xsl:when test="preceding-sibling::refnamediv">
          <!-- no title on secondary refnamedivs! -->
        </xsl:when>
        <xsl:when test="$refentry.generate.name != 0">
          <h2>
            <xsl:call-template name="gentext">
              <xsl:with-param name="key" select="'RefName'" />
            </xsl:call-template>
          </h2>
        </xsl:when>
        <xsl:when test="$refentry.generate.title != 0">
          <h2>
            <xsl:choose>
              <xsl:when test="../refmeta/refentrytitle">
                <xsl:apply-templates select="../refmeta/refentrytitle" />
              </xsl:when>
              <xsl:otherwise>
                <xsl:apply-templates select="refname[1]" mode="title" />
              </xsl:otherwise>
            </xsl:choose>
          </h2>
        </xsl:when>
      </xsl:choose>

      <p>
      <xsl:choose>
        <xsl:when test="preceding-sibling::refnamediv or following-sibling::refnamediv">
          <xsl:apply-templates mode="reference.fullname" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:apply-templates />
        </xsl:otherwise>
      </xsl:choose>
      </p>
    </div>
  </xsl:template>

  <xsl:template match="refname">
  </xsl:template>

  <xsl:template match="refpurpose">
    <xsl:apply-templates />
  </xsl:template>

  <xsl:template match="refname" mode="reference.fullname">
    <xsl:if test="not(preceding-sibling::refdescriptor)">
      <xsl:apply-templates/>
      <xsl:if test="following-sibling::refname">
        <xsl:text>, </xsl:text>
      </xsl:if>
    </xsl:if>
  </xsl:template>

  <xsl:template match="refpurpose" mode="reference.fullname">
    <xsl:text> </xsl:text>
    <xsl:call-template name="dingbat">
      <xsl:with-param name="dingbat">em-dash</xsl:with-param>
    </xsl:call-template>
    <xsl:text> </xsl:text>
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="refsynopsisdiv">
    <div class="{name(.)}">
      <xsl:call-template name="anchor"/>
      <xsl:if test="refsynopsisdiv/title|title">
        <h2>
          <xsl:apply-templates select="(refsynopsisdiv/title|title)[1]" mode="titlepage.mode"/>
        </h2>
      </xsl:if>
      <xsl:apply-templates/>
    </div>
  </xsl:template>

  <xsl:template match="varlistentry" mode="varlist-table">
    <xsl:variable name="presentation">
      <xsl:call-template name="dbhtml-attribute">
        <xsl:with-param name="pis" select="../processing-instruction('dbhtml')" />
        <xsl:with-param name="attribute" select="'term-presentation'" />
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="pi-separator">
      <xsl:call-template name="dbhtml-attribute">
        <xsl:with-param name="pis" select="../processing-instruction('dbhtml')" />
        <xsl:with-param name="attribute" select="'term-separator'" />
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="separator">
      <xsl:choose>
        <xsl:when test="$pi-separator != ''">
          <xsl:value-of select="$pi-separator" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="':'" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <tr>
      <xsl:call-template name="tr.attributes">
        <xsl:with-param name="rownum">
          <xsl:number from="variablelist" count="varlistentry" />
        </xsl:with-param>
      </xsl:call-template>

      <th>
        <xsl:call-template name="anchor"/>
        <xsl:choose>
          <xsl:when test="$presentation = 'bold'">
            <b>
              <xsl:apply-templates select="term"/>
              <xsl:value-of select="$separator"/>
            </b>
          </xsl:when>
          <xsl:when test="$presentation = 'italic'">
            <i>
              <xsl:apply-templates select="term"/>
              <xsl:value-of select="$separator"/>
            </i>
          </xsl:when>
          <xsl:when test="$presentation = 'bold-italic'">
            <b>
              <i>
                <xsl:apply-templates select="term"/>
                <xsl:value-of select="$separator"/>
              </i>
            </b>
          </xsl:when>
          <xsl:otherwise>
            <xsl:apply-templates select="term"/>
            <xsl:value-of select="$separator"/>
          </xsl:otherwise>
        </xsl:choose>
      </th>
      <td>
        <xsl:apply-templates select="listitem"/>
      </td>
    </tr>
  </xsl:template>

  <xsl:template match="segmentedlist" mode="seglist-table">
    <xsl:variable name="table-summary">
      <xsl:call-template name="dbhtml-attribute">
        <xsl:with-param name="pis" select="processing-instruction('dbhtml')"/>
        <xsl:with-param name="attribute" select="'table-summary'"/>
      </xsl:call-template>
    </xsl:variable>

    <xsl:variable name="list-width">
      <xsl:call-template name="dbhtml-attribute">
        <xsl:with-param name="pis" select="processing-instruction('dbhtml')"/>
        <xsl:with-param name="attribute" select="'list-width'"/>
      </xsl:call-template>
    </xsl:variable>

    <xsl:apply-templates select="title"/>

    <table border="0" cellpadding="2" cellspacing="0">
      <xsl:if test="$list-width != ''">
        <xsl:attribute name="width">
          <xsl:value-of select="$list-width"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:if test="$table-summary != ''">
        <xsl:attribute name="summary">
          <xsl:value-of select="$table-summary"/>
        </xsl:attribute>
      </xsl:if>
      <thead>
        <tr class="segtitle">
          <xsl:call-template name="tr.attributes">
            <xsl:with-param name="row" select="segtitle[1]"/>
            <xsl:with-param name="rownum" select="1"/>
          </xsl:call-template>
          <xsl:apply-templates select="segtitle" mode="seglist-table"/>
        </tr>
      </thead>
      <tbody>
        <xsl:apply-templates select="seglistitem" mode="seglist-table"/>
      </tbody>
    </table>
  </xsl:template>

  <xsl:template match="segmentedlist/title">
    <div class="title">
      <span class="title"><xsl:apply-templates/></span>
    </div>
  </xsl:template>

  <xsl:template match="seg" mode="seglist-table">
    <td class="seg"><xsl:apply-templates/></td>
  </xsl:template>

  <xsl:template match="seg[1]" mode="seglist-table">
    <td class="segkey">
      <xsl:call-template name="anchor">
        <xsl:with-param name="node" select="ancestor::seglistitem"/>
      </xsl:call-template>
      <xsl:apply-templates/>
    </td>
  </xsl:template>

  <xsl:template match="inlinelist">
    <span class="{name(.)}">
      <xsl:call-template name="anchor" />
      <xsl:apply-templates select="member" />
    </span>
  </xsl:template>

  <xsl:template match="inlinelist/member">
    <xsl:apply-templates />
    <xsl:if test="not(position()=last())">
      <xsl:text>, </xsl:text>
    </xsl:if>
  </xsl:template>


  <xsl:template name="script.refentry.href">
    <xsl:param name="refentry" select="." />
    <xsl:variable name="href">
      <xsl:call-template name="href.target.uri">
        <xsl:with-param name="object" select="$refentry" />
      </xsl:call-template>
    </xsl:variable>
    <a href="{$href}">
      <xsl:if test="$refentry/refnamediv/refpurpose">
        <xsl:attribute name="title">
          <xsl:value-of select="$refentry/refnamediv/refpurpose" />
        </xsl:attribute>
      </xsl:if>
      <xsl:call-template name="inline.charseq" />
    </a>
  </xsl:template>

  <xsl:template match="script">
    <xsl:choose>
      <xsl:when test="@moreinfo='refentry' and key('refname',.)">
        <xsl:variable name="refentry" select="key('refname',.)" />
        <xsl:choose>
          <xsl:when test="$refentry[ancestor::section = current()/ancestor::section]">
            <xsl:call-template name="script.refentry.href">
              <xsl:with-param name="refentry" select="$refentry[ancestor::section = current()/ancestor::section]/.." />
            </xsl:call-template>
          </xsl:when>
          <xsl:otherwise>
            <xsl:call-template name="script.refentry.href">
              <xsl:with-param name="refentry" select="$refentry[1]/.." />
            </xsl:call-template>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="inline.charseq" />
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="application">
    <xsl:call-template name="inline.charseq" />
  </xsl:template>

  <xsl:template match="filename">
    <xsl:call-template name="inline.charseq" />
  </xsl:template>

  <xsl:template match="parameter">
    <xsl:call-template name="inline.charseq" />
  </xsl:template>

  <xsl:template match="property">
    <xsl:call-template name="inline.charseq" />
  </xsl:template>

  <xsl:template match="symbol">
    <xsl:call-template name="inline.charseq" />
  </xsl:template>

  <xsl:template match="message">
    <xsl:call-template name="inline.charseq" />
  </xsl:template>

  <xsl:template match="flavor">
    <xsl:call-template name="inline.charseq" />
  </xsl:template>

  <xsl:template match="metaproperty">
    <xsl:call-template name="inline.charseq" />
  </xsl:template>

  <xsl:template match="stimulus">
    <xsl:call-template name="inline.charseq" />
  </xsl:template>

  <xsl:template match="qvar">
    <xsl:call-template name="inline.charseq" />
  </xsl:template>

  <xsl:template match="object">
    <xsl:call-template name="inline.charseq" />
  </xsl:template>

  <xsl:template match="osm">
    <xsl:call-template name="inline.charseq" />
  </xsl:template>

  <xsl:template match="command">
    <xsl:call-template name="inline.charseq" />
  </xsl:template>

  <xsl:template match="replaceable">
    <xsl:call-template name="inline.charseq" />
  </xsl:template>

  <xsl:template match="constant">
    <xsl:call-template name="inline.charseq" />
  </xsl:template>

  <xsl:template match="varname">
    <xsl:call-template name="inline.charseq" />
  </xsl:template>

  <xsl:template match="userinput">
    <xsl:call-template name="inline.charseq" />
  </xsl:template>

</xsl:stylesheet>