/******************************************************************************
 *    strtocolor.cpp
 *
 *    This file is part of Object Script Library
 *    Copyright (C) 2005-2007 Tom N Harris <telliamed@whoopdedo.org>
 *
 *    Permission is hereby granted, free of charge, to any person obtaining
 *    a copy of this software and associated documentation files (the 
 *    "Software"), to deal in the Software without restriction, including 
 *    without limitation the rights to use, copy, modify, merge, publish, 
 *    distribute, sublicense, and/or sell copies of the Software, and to 
 *    permit persons to whom the Software is furnished to do so.
 *    
 *    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
 *    EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES 
 *    OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-
 *    INFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS 
 *    BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN 
 *    AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR 
 *    IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN 
 *    THE SOFTWARE.
 *
 *****************************************************************************/

#include <stdio.h>
#include <string.h>

static const unsigned char g_cHexTable[] = {
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,        0,1,2,3,4,5,6,7,8,9,0,0,0,0,0,0,
	0,10,11,12,13,14,15,0,0,0,0,0,0,0,0,0,  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,10,11,12,13,14,15,0,0,0,0,0,0,0,0,0,  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
};

typedef struct colorname_
{
	const char* n;
	unsigned long c;
} colorname;
static const colorname g_sColorNames[] = {
	{ "black",   0x000000 },
	{ "silver",  0xC0C0C0 },
	{ "gray",    0x808080 },
	{ "grey",    0x808080 },
	{ "white",   0xFFFFFF },
	{ "maroon",  0x000080 },
	{ "red",     0x0000FF },
	{ "purple",  0x800080 },
	{ "fuchsia", 0xFF00FF },
	{ "green",   0x008000 },
	{ "lime",    0x00FF00 },
	{ "olive",   0x008080 },
	{ "yellow",  0x00FFFF },
	{ "navy",    0x800000 },
	{ "blue",    0xFF0000 },
	{ "teal",    0x808000 },
	{ "aqua",    0xFFFF00 }
};

int strtocolor(const char* str)
{
	register unsigned char* c = reinterpret_cast<unsigned char*>(const_cast<char*>(str));
	if (*c == '#')
	{
		if (strlen(reinterpret_cast<char*>(++c)) < 6)
			return 0;
		unsigned char r,g,b;
		r  = g_cHexTable[*c++] << 4;
		r |= g_cHexTable[*c++];
		g  = g_cHexTable[*c++] << 4;
		g |= g_cHexTable[*c++];
		b  = g_cHexTable[*c++] << 4;
		b |= g_cHexTable[*c];
		return (r|(g<<8)|(b<<16));
	}
	if (strchr(str, ','))
	{
		unsigned int r,g,b;
		if (3 == sscanf(str, "%u , %u , %u", &r, &g, &b))
		{
			return ((r&0xFF)|((g&0xFF)<<8)|((b&0xFF)<<16));
		}
	}
	else
	{
		for (unsigned int n=0; n < sizeof(g_sColorNames)/sizeof(g_sColorNames[0]); ++n)
		{
			if (!stricmp(str,g_sColorNames[n].n))
				return g_sColorNames[n].c;
		}
	}
	return 0;
}
