/******************************************************************************
 *    ShowBook.cpp
 *
 *    This file is part of Object Script Library
 *    Copyright (C) 2005-2007 Tom N Harris <telliamed@whoopdedo.org>
 *
 *    Permission is hereby granted, free of charge, to any person obtaining
 *    a copy of this software and associated documentation files (the 
 *    "Software"), to deal in the Software without restriction, including 
 *    without limitation the rights to use, copy, modify, merge, publish, 
 *    distribute, sublicense, and/or sell copies of the Software, and to 
 *    permit persons to whom the Software is furnished to do so.
 *    
 *    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
 *    EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES 
 *    OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-
 *    INFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS 
 *    BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN 
 *    AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR 
 *    IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN 
 *    THE SOFTWARE.
 *
 *****************************************************************************/

#include "ScriptLib.h"

#include <string.h>
#include <malloc.h>

int ShowBook(int iObject, bool bArt, int iTime)
{
#if (_DARKGAME == 3)
	SService<IPropertySrv> pPS(g_pScriptManager);
	if (!pPS->Possessed(iObject, "UseMsg"))
		return 1;
	SService<IShockGameSrv> pShock(g_pScriptManager);
	pShock->AddTextObjProp(iObject, "UseMsg", 0, iTime);
#else
	SService<IPropertySrv> pPS(g_pScriptManager);
	if (!pPS->Possessed(iObject, "Book"))
		return 1;
	cMultiParm mpBook, mpBookArt;
	pPS->Get(mpBook, iObject, "Book", NULL);
	if (!*mpBook.psz)
	{
		return 1;
	}
	SService<IDarkUISrv> pUI(g_pScriptManager);
	if (bArt && pPS->Possessed(iObject, "BookArt"))
	{
		pPS->Get(mpBookArt, iObject, "BookArt", NULL);
		pUI->ReadBook(mpBook, mpBookArt);
	}
	else
	{
		SService<IDataSrv> pDS(g_pScriptManager);
		char* szBookFile = reinterpret_cast<char*>(alloca(strlen(mpBook) + 10));
		strcpy(szBookFile, "..\\books\\");
		strcat(szBookFile, mpBook);
		cScrStr str;
		pDS->GetString(str, szBookFile, "page_0", "", "strings");
		if (*static_cast<const char*>(str))
		{
			if (iTime == 0)
				iTime = CalcTextTime(str, 500);
			pUI->TextMessage(str, 0, iTime);
		}
		str.Free();
	}
#endif
	return 0;
}
