/******************************************************************************
 *    RemoveSingleMetaProperty.cpp
 *
 *    This file is part of Object Script Library
 *    Copyright (C) 2005-2007 Tom N Harris <telliamed@whoopdedo.org>
 *
 *    Permission is hereby granted, free of charge, to any person obtaining
 *    a copy of this software and associated documentation files (the 
 *    "Software"), to deal in the Software without restriction, including 
 *    without limitation the rights to use, copy, modify, merge, publish, 
 *    distribute, sublicense, and/or sell copies of the Software, and to 
 *    permit persons to whom the Software is furnished to do so.
 *    
 *    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
 *    EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES 
 *    OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-
 *    INFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS 
 *    BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN 
 *    AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR 
 *    IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN 
 *    THE SOFTWARE.
 *
 *****************************************************************************/

#include "ScriptLib.h"

static int DoRemoveMetaProperty(IObjectSrv* pOS, object oMetaProp, object oObject)
{
	int iRet = 0;
	true_bool has_mp;
	pOS->HasMetaProperty(has_mp, oObject, oMetaProp);
	if (has_mp)
	{
		iRet = pOS->RemoveMetaProperty(oObject, oMetaProp);
		//pOS->HasMetaProperty(has_mp, oObject, oMetaProp);
	}
	return iRet;
}

int RemoveSingleMetaProperty(const char* pszMetaProp, int iObjId)
{
	SService<IObjectSrv> pOS(g_pScriptManager);
	object oMetaProp;
	pOS->Named(oMetaProp, pszMetaProp);
	if (oMetaProp != 0)
		return DoRemoveMetaProperty(pOS, oMetaProp, iObjId);
	return 0;
}

int RemoveSingleMetaProperty(int iMetaProp, int iObjId)
{
	SService<IObjectSrv> pOS(g_pScriptManager);
	return DoRemoveMetaProperty(pOS, iMetaProp, iObjId);
}
