/******************************************************************************
 *    DebugPrintf.cpp
 *
 *    This file is part of Object Script Library
 *    Copyright (C) 2005-2007 Tom N Harris <telliamed@whoopdedo.org>
 *
 *    Permission is hereby granted, free of charge, to any person obtaining
 *    a copy of this software and associated documentation files (the 
 *    "Software"), to deal in the Software without restriction, including 
 *    without limitation the rights to use, copy, modify, merge, publish, 
 *    distribute, sublicense, and/or sell copies of the Software, and to 
 *    permit persons to whom the Software is furnished to do so.
 *    
 *    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
 *    EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES 
 *    OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-
 *    INFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS 
 *    BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN 
 *    AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR 
 *    IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN 
 *    THE SOFTWARE.
 *
 *****************************************************************************/

#include "ScriptLib.h"

extern int (__cdecl *g_pfnMPrintf)(const char*, ...);

#include <stdio.h>
#include <stdarg.h>

// vs[n]printf is pre-C99 in msvcrt6, 
// so we can't dynamically allocate a buffer.
// 1000 is a limit imposed by Dromed's mprint 
void DebugPrintf(const char* pszFormat, ...)
{
	va_list va;
	char psz[1000];
	va_start(va, pszFormat);
	int iLen = _vsnprintf(psz, 999, pszFormat, va);
	va_end(va);

	if (g_pfnMPrintf)
	{
		g_pfnMPrintf("%s\n", psz);
	}
	else
	{
		IDebugScrSrv* pDSS = static_cast<IDebugScrSrv*>(g_pScriptManager->GetService(IID_IDebugScriptService));
		if (!pDSS)
		{
			return;
		}
		cScrStr nil;
		pDSS->MPrint(psz, nil, nil, nil, nil, nil, nil, nil);
		pDSS->Release();
	}
#ifdef DEBUG
	ShowString(psz, 1000 + (iLen * 50));
#else
	iLen = iLen;
#endif
}
