/******************************************************************************
 *    T1Scripts.h
 *
 *    This file is part of Public Scripts
 *    Copyright (C) 2005-2007 Tom N Harris <telliamed@whoopdedo.org>
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *****************************************************************************/
#ifndef T1SCRIPTS_H
#define T1SCRIPTS_H

#if (_DARKGAME == 1)

#ifndef SCR_GENSCRIPTS
#include "BaseScript.h"
#include "BaseTrap.h"

#include <lg/scrservices.h>
#include <lg/links.h>
#endif // SCR_GENSCRIPTS


/**
 * Script: TrapOffFilter
 * Inherits: BaseScript
 * Messages: TurnOff
 */
#if !SCR_GENSCRIPTS
class cScr_TrapOffFilter : public cBaseScript
{
public:
	cScr_TrapOffFilter(const char* pszName, int iHostObjId)
		: cBaseScript(pszName, iHostObjId)
	{ }

protected:
	virtual long OnTurnOff(sScrMsg*, cMultiParm&);
};
#else // SCR_GENSCRIPTS
GEN_FACTORY("TrapOffFilter","BaseScript",cScr_TrapOffFilter)
#endif // SCR_GENSCRIPTS

/**
 * Script: TrapOnce
 * Inherits: BaseScript
 * Messages: TurnOn, TurnOff
 */
#if !SCR_GENSCRIPTS
class cScr_TrapOnce : public cBaseScript
{
public:
	cScr_TrapOnce(const char* pszName, int iHostObjId)
		: cBaseScript(pszName, iHostObjId)
	{ }

protected:
	virtual long OnTurnOn(sScrMsg*, cMultiParm&);
	virtual long OnTurnOff(sScrMsg*, cMultiParm&);
};
#else // SCR_GENSCRIPTS
GEN_FACTORY("TrapOnce","BaseScript",cScr_TrapOnce)
#endif // SCR_GENSCRIPTS

/**
 * Script: TrapRevert
 * Inherits: BaseScript
 * Messages: TurnOn, TurnOff, Timer
 * Properties: Script\Timing
 */
#if !SCR_GENSCRIPTS
class cScr_TrapRevert : public cBaseScript
{
public:
	cScr_TrapRevert(const char* pszName, int iHostObjId)
		: cBaseScript(pszName, iHostObjId)
	{ }

protected:
	virtual long OnTurnOn(sScrMsg*, cMultiParm&);
	virtual long OnTurnOff(sScrMsg*, cMultiParm&);
	virtual long OnTimer(sScrTimerMsg*, cMultiParm&);
};
#else // SCR_GENSCRIPTS
GEN_FACTORY("TrapRevert","BaseScript",cScr_TrapRevert)
#endif // SCR_GENSCRIPTS

/**
 * Script: TrapDirection
 * Inherits: BaseTrap
 */
#if !SCR_GENSCRIPTS
class cScr_TrapDirection : public cBaseTrap
{
public:
	cScr_TrapDirection(const char* pszName, int iHostObjId)
		: cBaseTrap(pszName, iHostObjId)
	{ }

protected:
	virtual long OnSwitch(bool, sScrMsg*, cMultiParm&);
};
#else // SCR_GENSCRIPTS
GEN_FACTORY("TrapDirection","BaseTrap",cScr_TrapDirection)
#endif // SCR_GENSCRIPTS

/**
 * Script: TrapPatroller
 * Inherits: BaseTrap
 * Links: ControlDevice
 * Properties: AI\Ability Settings\Patrol: Does patrol
 */
#if !SCR_GENSCRIPTS
class cScr_TrapPatroller : public cBaseTrap
{
public:
	cScr_TrapPatroller(const char* pszName, int iHostObjId)
		: cBaseTrap(pszName, iHostObjId)
	{ }

private:
	static int LinkIter(ILinkSrv* pLS, ILinkQuery* pLQ, IScript* pScript, void* pData);

protected:
	virtual long OnSwitch(bool, sScrMsg*, cMultiParm&);
};
#else // SCR_GENSCRIPTS
GEN_FACTORY("TrapPatroller","BaseTrap",cScr_TrapPatroller)
#endif // SCR_GENSCRIPTS

/**
 * Script: TrapNonFinalComplete
 * Inherits: BaseTrap
 * Messages: QuestChange
 * QVars: goal_state_*, goal_visible_*
 */
#if !SCR_GENSCRIPTS
class cScr_TrapNonFinalComplete : public cBaseTrap
{
public:
	cScr_TrapNonFinalComplete(const char* pszName, int iHostObjId)
		: cBaseTrap(pszName, iHostObjId)
	{ }

private:
	bool EvaluateGoals(int num_goals);

protected:
	virtual long OnBeginScript(sScrMsg*, cMultiParm&);
	virtual long OnEndScript(sScrMsg*, cMultiParm&);
	virtual long OnQuestChange(sQuestMsg*, cMultiParm&);
	virtual long OnSim(sSimMsg*, cMultiParm&);
};
#else // SCR_GENSCRIPTS
GEN_FACTORY("TrapNonFinalComplete","BaseTrap",cScr_TrapNonFinalComplete)
#endif // SCR_GENSCRIPTS

/**
 * Script: TrapTexture
 * Inherits: BaseTrap
 * Properties: Script\TerrReplaceOn, Script\TerrReplaceOff, Engine Features\Retexture Radius
 */
#if !SCR_GENSCRIPTS
class cScr_TrapTexture : public cBaseTrap
{
public:
	cScr_TrapTexture(const char* pszName, int iHostObjId)
		: cBaseTrap(pszName, iHostObjId)
	{ }

protected:
	virtual long OnSwitch(bool, sScrMsg*, cMultiParm&);
};
#else // SCR_GENSCRIPTS
GEN_FACTORY("TrapTexture","BaseTrap",cScr_TrapTexture)
#endif // SCR_GENSCRIPTS

/**
 * Script: TrigOBBPlayer
 * Inherits: BaseTrap
 * Messages: PhysEnter, PhysExit
 * Schemas: "Event Activate", "Event Deactivate"
 */
#if !SCR_GENSCRIPTS
class cScr_TrigOBBPlayer : public cBaseTrap
{
public:
	cScr_TrigOBBPlayer(const char* pszName, int iHostObjId)
		: cBaseTrap(pszName, iHostObjId)
	{ }

protected:
	virtual long OnBeginScript(sScrMsg*, cMultiParm&);
	virtual long OnEndScript(sScrMsg*, cMultiParm&);
	virtual long OnPhysEnter(sPhysMsg*, cMultiParm&);
	virtual long OnPhysExit(sPhysMsg*, cMultiParm&);
};
#else // SCR_GENSCRIPTS
GEN_FACTORY("TrigOBBPlayer","BaseTrap",cScr_TrigOBBPlayer)
#endif // SCR_GENSCRIPTS

/**
 * Script: TrigRoomPopChange
 * Inherits: BaseRoomScript
 * Messages: CreatureRoomEnter, CreatureRoomExit, PlayerRoomEnter, PlayerRoomExit
 * Links: ControlDevice
 */
#if !SCR_GENSCRIPTS
class cScr_TrigRoomPopChange : public cBaseRoomScript
{
public:
	cScr_TrigRoomPopChange(const char* pszName, int iHostObjId)
		: cBaseRoomScript(pszName, iHostObjId)
	{ }

protected:
	virtual long OnCreatureRoomEnter(sRoomMsg*, cMultiParm&);
	virtual long OnCreatureRoomExit(sRoomMsg*, cMultiParm&);
	virtual long OnPlayerRoomEnter(sRoomMsg*, cMultiParm&);
	virtual long OnPlayerRoomExit(sRoomMsg*, cMultiParm&);
};
#else // SCR_GENSCRIPTS
GEN_FACTORY("TrigRoomPopChange","BaseRoomScript",cScr_TrigRoomPopChange)
#endif // SCR_GENSCRIPTS

/**
 * Script: TrigRoomObject
 * Inherits: BaseRoomScript
 * Messages: ObjRoomTransit
 * Links: ControlDevice, Route
 */
#if !SCR_GENSCRIPTS
class cScr_TrigRoomObject : public cBaseRoomScript
{
public:
	cScr_TrigRoomObject(const char* pszName, int iHostObjId)
		: cBaseRoomScript(pszName, iHostObjId)
	{ }

protected:
	virtual long OnBeginScript(sScrMsg*, cMultiParm&);
	virtual long OnObjRoomTransit(sRoomMsg*, cMultiParm&);

	virtual void ObjEnteringRoom(void);
	virtual void ObjExitingRoom(void);
	bool ObjIsInRoom(void);
};
#else // SCR_GENSCRIPTS
GEN_FACTORY("TrigRoomObject","BaseRoomScript",cScr_TrigRoomObject)
#endif // SCR_GENSCRIPTS

/**
 * Script: TrigRoomDelivery
 * Inherits: TrigRoomObject
 * Messages: Contained
 */
#if !SCR_GENSCRIPTS
class cScr_TrigRoomDelivery : public cScr_TrigRoomObject
{
public:
	cScr_TrigRoomDelivery(const char* pszName, int iHostObjId)
		: cScr_TrigRoomObject(pszName, iHostObjId)
	{ }

protected:
	virtual long OnContained(sContainedScrMsg*, cMultiParm&);

	virtual void ObjEnteringRoom(void);
	virtual void ObjExitingRoom(void);
};
#else // SCR_GENSCRIPTS
GEN_FACTORY("TrigRoomDelivery","TrigRoomObject",cScr_TrigRoomDelivery)
#endif // SCR_GENSCRIPTS

/**
 * Script: TrigRoomDeposit
 * Inherits: TrigRoomObject
 * Messages: Contained
 */
#if !SCR_GENSCRIPTS
class cScr_TrigRoomDeposit : public cScr_TrigRoomObject
{
public:
	cScr_TrigRoomDeposit(const char* pszName, int iHostObjId)
		: cScr_TrigRoomObject(pszName, iHostObjId)
	{ }

protected:
	virtual long OnContained(sContainedScrMsg*, cMultiParm&);

	virtual void ObjEnteringRoom(void);
	virtual void ObjExitingRoom(void);
};
#else // SCR_GENSCRIPTS
GEN_FACTORY("TrigRoomDeposit","TrigRoomObject",cScr_TrigRoomDeposit)
#endif // SCR_GENSCRIPTS

#if !SCR_GENSCRIPTS
/**
 * Script: BaseFindSecret
 * Properties: Dark GameSys\Stats
 * QVars: DrSSecrets, DrSScrtCnt
 */
class cBaseFindSecret
{
public:
	cBaseFindSecret(int iHostObjId)
		: m_iObjId(iHostObjId)
	{ }

private:
	int m_iObjId;

protected:
	void InitHidden(void);
	void FindHidden(void);
};
#endif // SCR_GENSCRIPTS

/**
 * Script: TrapFindSecret
 * Inherits: BaseTrap, BaseFindSecret
 */
#if !SCR_GENSCRIPTS
class cScr_TrapFindSecret : public cBaseTrap, protected cBaseFindSecret
{
public:
	cScr_TrapFindSecret(const char* pszName, int iHostObjId)
		: cBaseTrap(pszName, iHostObjId),
		  cBaseFindSecret(iHostObjId)
	{ }

protected:
	virtual long OnBeginScript(sScrMsg*, cMultiParm&);
	virtual long OnSwitch(bool, sScrMsg*, cMultiParm&);
};
#else // SCR_GENSCRIPTS
GEN_FACTORY("TrapFindSecret","BaseTrap",cScr_TrapFindSecret)
#endif // SCR_GENSCRIPTS

/**
 * Script: FrobFind
 * Inherits: BaseScript, BaseFindSecret
 * Messages: FrobWorldEnd
 */
#if !SCR_GENSCRIPTS
class cScr_FrobFind : public cBaseScript, protected cBaseFindSecret
{
public:
	cScr_FrobFind(const char* pszName, int iHostObjId)
		: cBaseScript(pszName, iHostObjId),
		  cBaseFindSecret(iHostObjId)
	{ }

protected:
	virtual long OnBeginScript(sScrMsg*, cMultiParm&);
	virtual long OnFrobWorldEnd(sFrobMsg*, cMultiParm&);
};
#else // SCR_GENSCRIPTS
GEN_FACTORY("FrobFind","BaseScript",cScr_FrobFind)
#endif // SCR_GENSCRIPTS

/**
 * Script: SlayFind
 * Inherits: BaseScript, BaseFindSecret
 * Messages: Slain
 */
#if !SCR_GENSCRIPTS
class cScr_SlayFind : public cBaseScript, protected cBaseFindSecret
{
public:
	cScr_SlayFind(const char* pszName, int iHostObjId)
		: cBaseScript(pszName, iHostObjId),
		  cBaseFindSecret(iHostObjId)
	{ }

protected:
	virtual long OnBeginScript(sScrMsg*, cMultiParm&);
	virtual long OnSlain(sSlayMsg*, cMultiParm&);
};
#else // SCR_GENSCRIPTS
GEN_FACTORY("SlayFind","BaseScript",cScr_SlayFind)
#endif // SCR_GENSCRIPTS

/**
 * Script: HiddenDoor
 * Inherits: BaseDoorScript, BaseFindSecret
 * Messages: DoorOpen
 */
#if !SCR_GENSCRIPTS
class cScr_HiddenDoor : public cBaseDoorScript, protected cBaseFindSecret
{
public:
	cScr_HiddenDoor(const char* pszName, int iHostObjId)
		: cBaseDoorScript(pszName, iHostObjId),
		  cBaseFindSecret(iHostObjId)
	{ }

protected:
	virtual long OnBeginScript(sScrMsg*, cMultiParm&);
	virtual long OnDoorOpen(sDoorMsg*, cMultiParm&);
};
#else // SCR_GENSCRIPTS
GEN_FACTORY("HiddenDoor","BaseDoorScript",cScr_HiddenDoor)
#endif // SCR_GENSCRIPTS

/**
 * Script: NonAutoDoor
 * Inherits: BaseDoorScript
 * Messages: DoorOpen, DoorClose, DoorOpening, DoorClosing, DoorHalt, TurnOn, TurnOff, FrobWorldEnd, Slain, NowLocked, NowUnlocked, SynchUp, PlayerToolFrob
 * Links: ScriptParams("Double")
 * Properties: Door\Rotating, Door\Translating, Engine Features\Locked
 * Schemas: "Event StateChange, OpenState, OldOpenState", "Event Reject, Operation OpenDoor"
 */
#if !SCR_GENSCRIPTS
class cScr_NonAutoDoor : public cBaseDoorScript
{
public:
	cScr_NonAutoDoor(const char* pszName, int iHostObjId)
		: cBaseDoorScript(pszName, iHostObjId)
	{ }

private:
	eDoorState TargetState(eDoorState);
	cAnsiStr StateChangeTags(eDoorAction,eDoorAction);
	void PingDoubles(void);

protected:
	virtual long OnNowLocked(sScrMsg*, cMultiParm&);
	virtual long OnNowUnlocked(sScrMsg*, cMultiParm&);
	virtual long OnFrobWorldEnd(sFrobMsg*, cMultiParm&);
	virtual long OnSlain(sSlayMsg*, cMultiParm&);
	virtual long OnDoorOpen(sDoorMsg*, cMultiParm&);
	virtual long OnDoorClose(sDoorMsg*, cMultiParm&);
	virtual long OnDoorOpening(sDoorMsg*, cMultiParm&);
	virtual long OnDoorClosing(sDoorMsg*, cMultiParm&);
	virtual long OnDoorHalt(sDoorMsg*, cMultiParm&);
	virtual long OnMessage(sScrMsg*, cMultiParm&);
	virtual long OnTurnOn(sScrMsg*, cMultiParm&);
	virtual long OnTurnOff(sScrMsg*, cMultiParm&);
};
#else // SCR_GENSCRIPTS
GEN_FACTORY("NonAutoDoor","BaseDoorScript",cScr_NonAutoDoor)
#endif // SCR_GENSCRIPTS

/**
 * Script: TransformLock
 * Inherits: BaseScript
 * Messages: NowUnlocked
 * Properties: Tweq\Models
 */
#if !SCR_GENSCRIPTS
class cScr_TransformLock : public cBaseScript
{
public:
	cScr_TransformLock(const char* pszName, int iHostObjId)
		: cBaseScript(pszName, iHostObjId)
	{ }

protected:
	virtual long OnNowUnlocked(sScrMsg*, cMultiParm&);
};
#else // SCR_GENSCRIPTS
GEN_FACTORY("TransformLock","BaseScript",cScr_TransformLock)
#endif // SCR_GENSCRIPTS

/**
 * Script: CleanUpAttack
 * Inherits: BaseAIScript
 * Messages: AIModeChange, AbortAttack
 */
#if !SCR_GENSCRIPTS
class cScr_CleanUpAttack : public cBaseAIScript
{
public:
	cScr_CleanUpAttack(const char* pszName, int iHostObjId)
		: cBaseAIScript(pszName, iHostObjId)
	{ }

protected:
	virtual long OnAIModeChange(sAIModeChangeMsg*, cMultiParm&);
};
#else // SCR_GENSCRIPTS
GEN_FACTORY("CleanUpAttack","BaseAIScript",cScr_CleanUpAttack)
#endif // SCR_GENSCRIPTS

/**
 * Script: NoPingBack
 * Inherits: BaseAIScript
 * Messages: AIModeChange
 * Metaproperties: NoPingBack
 */
#if !SCR_GENSCRIPTS
class cScr_NoPingBack : public cBaseAIScript
{
public:
	cScr_NoPingBack(const char* pszName, int iHostObjId)
		: cBaseAIScript(pszName, iHostObjId)
	{ }

protected:
	virtual long OnAIModeChange(sAIModeChangeMsg*, cMultiParm&);
};
#else // SCR_GENSCRIPTS
GEN_FACTORY("NoPingBack","BaseAIScript",cScr_NoPingBack)
#endif // SCR_GENSCRIPTS

/**
 * Script: NoticesPlayerBumps
 * Inherits: BaseAIScript
 * Messages: PhysCollision
 * Properties: AI\AI Core\Alertness cap
 */
#if !SCR_GENSCRIPTS
class cScr_NoticesPlayerBumps : public cBaseAIScript
{
public:
	cScr_NoticesPlayerBumps(const char* pszName, int iHostObjId)
		: cBaseAIScript(pszName, iHostObjId)
	{ }

protected:
	virtual long OnBeginScript(sScrMsg*, cMultiParm&);
	virtual long OnEndScript(sScrMsg*, cMultiParm&);
	virtual long OnTimer(sScrTimerMsg*, cMultiParm&);
	virtual long OnPhysCollision(sPhysMsg*, cMultiParm&);
};
#else // SCR_GENSCRIPTS
GEN_FACTORY("NoticesPlayerBumps","BaseAIScript",cScr_NoticesPlayerBumps)
#endif // SCR_GENSCRIPTS

/**
 * Script: ShutUpYerDead
 * Inherits: BaseScript
 * Messages: AIModeChange, IgnorePotion
 * Links: AIAwareness
 */
#if !SCR_GENSCRIPTS
class cScr_ShutUpYerDead : public cBaseScript
{
public:
	cScr_ShutUpYerDead(const char* pszName, int iHostObjId)
		: cBaseScript(pszName, iHostObjId)
	{ }

private:
	static int LinkIter(ILinkSrv* pLS, ILinkQuery* pLQ, IScript* pScript, void* pData);

protected:
	virtual long OnBeginScript(sScrMsg*, cMultiParm&);
};
#else // SCR_GENSCRIPTS
GEN_FACTORY("ShutUpYerDead","BaseScript",cScr_ShutUpYerDead)
#endif // SCR_GENSCRIPTS

/**
 * Script: SlayHaltSpeech
 * Inherits: BaseScript
 * Messages: Slain
 */
#if !SCR_GENSCRIPTS
class cScr_SlayHaltSpeech : public cBaseScript
{
public:
	cScr_SlayHaltSpeech(const char* pszName, int iHostObjId)
		: cBaseScript(pszName, iHostObjId)
	{ }

protected:
	virtual long OnSlain(sSlayMsg*, cMultiParm&);
};
#else // SCR_GENSCRIPTS
GEN_FACTORY("SlayHaltSpeech","BaseScript",cScr_SlayHaltSpeech)
#endif // SCR_GENSCRIPTS

/**
 * Script: TimedPotion
 * Inherits: BaseScript
 * Messages: FrobInvEnd, StartPotion
 * Links: ScriptParams("Potion")
 * Properties: Script\Timing, Engine Features\Combine Type
 */
#if !SCR_GENSCRIPTS
class cScr_TimedPotion : public cBaseScript
{
public:
	cScr_TimedPotion(const char* pszName, int iHostObjId);

private:
	static long HandleStartPotion(cScript*, sScrMsg*, sMultiParm*);

protected:
	virtual long OnBeginScript(sScrMsg*, cMultiParm&);
	virtual long OnTimer(sScrTimerMsg*, cMultiParm&);
	virtual long OnFrobInvEnd(sFrobMsg*, cMultiParm&);
	virtual long OnStartPotion(sScrMsg*, cMultiParm&);

	virtual void StartPotion(int, int) { }
	virtual void StopPotion(int) { }
};
#else // SCR_GENSCRIPTS
GEN_FACTORY("TimedPotion","BaseScript",cScr_TimedPotion)
#endif // SCR_GENSCRIPTS

/**
 * Script: Invisible
 * Inherits: BaseScript
 * Messages: Invisible
 * Links: AIAttack
 * Properties: AI\State\Current visibility
 */
#if !SCR_GENSCRIPTS
class cScr_Invisible : public cBaseScript
{
public:
	cScr_Invisible(const char* pszName, int iHostObjId)
		: cBaseScript(pszName, iHostObjId)
	{ }

protected:
	virtual long OnMessage(sScrMsg*, cMultiParm&);
};
#else // SCR_GENSCRIPTS
GEN_FACTORY("Invisible","BaseScript",cScr_Invisible)
#endif // SCR_GENSCRIPTS

/**
 * Script: InvisiPotion
 * Inherits: TimedPotion
 * Messages: Invisible, Visible
 * Properties: AI\State\Current visibility
 * Metaproperties: M-Invisible
 */
#if !SCR_GENSCRIPTS
class cScr_InvisiPotion : public cScr_TimedPotion
{
public:
	cScr_InvisiPotion(const char* pszName, int iHostObjId)
		: cScr_TimedPotion(pszName, iHostObjId)
	{ }

protected:
	virtual void StartPotion(int iFrobber, int iDuration);
	virtual void StopPotion(int iFrobber);
};
#else // SCR_GENSCRIPTS
GEN_FACTORY("InvisiPotion","TimedPotion",cScr_InvisiPotion)
#endif // SCR_GENSCRIPTS

/**
 * Script: LoGravPotion
 * Inherits: TimedPotion
 * Properties: Physics\Model\Attributes
 */
#if !SCR_GENSCRIPTS
class cScr_LoGravPotion : public cScr_TimedPotion
{
public:
	cScr_LoGravPotion(const char* pszName, int iHostObjId)
		: cScr_TimedPotion(pszName, iHostObjId)
	{ }

protected:
	virtual void StartPotion(int iFrobber, int iDuration);
	virtual void StopPotion(int iFrobber);
};
#else // SCR_GENSCRIPTS
GEN_FACTORY("LoGravPotion","TimedPotion",cScr_LoGravPotion)
#endif // SCR_GENSCRIPTS

/**
 * Script: LastMissionLoot
 * Inherits: BaseScript
 * Messages: Difficulty
 * Properties: Dark Gamesys\Loot
 * QVars: total_loot
 */
#if !SCR_GENSCRIPTS
class cScr_LastMissionLoot : public cBaseScript
{
public:
	cScr_LastMissionLoot(const char* pszName, int iHostObjId)
		: cBaseScript(pszName, iHostObjId)
	{ }

protected:
	virtual long OnDifficulty(sDiffScrMsg*, cMultiParm&);
};
#else // SCR_GENSCRIPTS
GEN_FACTORY("LastMissionLoot","BaseScript",cScr_LastMissionLoot)
#endif // SCR_GENSCRIPTS

/**
 * Script: PhysARContact
 * Inherits: BaseScript
 * Messages: PhysContactCreate, PhysContactDestroy
 */
#if !SCR_GENSCRIPTS
class cScr_PhysARContact : public cBaseScript
{
public:
	cScr_PhysARContact(const char* pszName, int iHostObjId)
		: cBaseScript(pszName, iHostObjId)
	{ }

protected:
	virtual long OnBeginScript(sScrMsg*, cMultiParm&);
	virtual long OnEndScript(sScrMsg*, cMultiParm&);
	virtual long OnPhysContactCreate(sPhysMsg*, cMultiParm&);
	virtual long OnPhysContactDestroy(sPhysMsg*, cMultiParm&);
};
#else // SCR_GENSCRIPTS
GEN_FACTORY("PhysARContact","BaseScript",cScr_PhysARContact)
#endif // SCR_GENSCRIPTS

/**
 * Script: ReGravitize
 * Inherits: BaseScript
 * Messages: PhysCollision
 * Properties: Physics\Model\Attributes
 */
#if !SCR_GENSCRIPTS
class cScr_ReGravitize : public cBaseScript
{
public:
	cScr_ReGravitize(const char* pszName, int iHostObjId)
		: cBaseScript(pszName, iHostObjId)
	{ }

protected:
	virtual long OnBeginScript(sScrMsg*, cMultiParm&);
	virtual long OnEndScript(sScrMsg*, cMultiParm&);
	virtual long OnPhysCollision(sPhysMsg*, cMultiParm&);
};
#else // SCR_GENSCRIPTS
GEN_FACTORY("ReGravitize","BaseScript",cScr_ReGravitize)
#endif // SCR_GENSCRIPTS

/**
 * Script: TrapSlayer
 * Inherits: BaseTrap
 * Links: ControlDevice
 * Properties: Game\Damage Model\Hit Points
 * Stimuli: BashStim
 */
#if !SCR_GENSCRIPTS
class cScr_SlayTrap : public cBaseTrap
{
public:
	cScr_SlayTrap(const char* pszName, int iHostObjId)
		: cBaseTrap(pszName, iHostObjId)
	{ }

private:
	static int LinkIter(ILinkSrv*, ILinkQuery*, IScript*, void*);

protected:
	virtual long OnSwitch(bool, sScrMsg*, cMultiParm&);
};
#else // SCR_GENSCRIPTS
GEN_FACTORY("TrapSlayer","BaseTrap",cScr_SlayTrap)
#endif // SCR_GENSCRIPTS

/**
 * Script: TrapTerminator
 * Inherits: BaseTrap
 * Links: ControlDevice
 */
#if !SCR_GENSCRIPTS
class cScr_ReallyDestroy : public cBaseTrap
{
public:
	cScr_ReallyDestroy(const char* pszName, int iHostObjId)
		: cBaseTrap(pszName, iHostObjId)
	{ }

private:
	static int LinkIter(ILinkSrv*, ILinkQuery*, IScript*, void*);

protected:
	virtual long OnSwitch(bool, sScrMsg*, cMultiParm&);
};
#else // SCR_GENSCRIPTS
GEN_FACTORY("TrapTerminator","BaseTrap",cScr_ReallyDestroy)
#endif // SCR_GENSCRIPTS


/*
TrapCapacitor
TrigContained
ModelByCount
HotPlate
HotPlateControl
LightFlare
IllumeBearer
MapSupplement
Roulette

LeverNoChain
DoubleButton
NumberButton
Odometer
GasLight
FlashMine
ActiveFlashMine
ActiveGasMine
Clock
BigClockFace
CameraAlert
CameraAlert2
TurretAlert
WorkerRobot
RoboSteam
RobotSlayScript
SummonMeBoiler
ConveyorBelt
DeployVine
Instrument
Victrola
Phantom
SubDoorJoints
VisitDecal
InstantiateSuspicious
SuspiciousReactions
ReactsNoisemakers
SecurityDoor

AllAIScript
AICheatScript
PlayerCheatScript
ContainWaterProp
DiffSpoof
Lugged
RainSound
SecretSounds
*/

#endif // _DARKGAME == 1

#endif // T1SCRIPTS_H
#ifdef SCR_GENSCRIPTS
#undef T1SCRIPTS_H
#endif
