/******************************************************************************
 *    ScriptModule.h
 *
 *    This file is part of Public Scripts
 *    Copyright (C) 2005-2007 Tom N Harris <telliamed@whoopdedo.org>
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *****************************************************************************/

#ifdef __BORLANDC__
#include <rpc.h>
#endif
#include <objbase.h>

#include <lg/script.h>
#include <lg/scrmanagers.h>

extern IMalloc *g_pMalloc;
extern IScriptMan *g_pScriptManager;

typedef int (__cdecl *MPrintfProc)(const char*, ...);
// GCC 3.3 is foolishly trying to optimize away the dereference here.
extern volatile MPrintfProc g_pfnMPrintf;

class cScriptModule : public IScriptModule
{
public:
	// IUnknown
	STDMETHOD(QueryInterface)(REFIID,void**);
	STDMETHOD_(ULONG,AddRef)(void);
	STDMETHOD_(ULONG,Release)(void);
	// IScriptModule
	STDMETHOD_(const char*,GetName)(void);
	STDMETHOD_(const sScrClassDesc*,GetFirstClass)(tScrIter*);
	STDMETHOD_(const sScrClassDesc*,GetNextClass)(tScrIter*);
	STDMETHOD_(void,EndClassIter)(tScrIter*);

private:
	int m_iRef;

public:
	virtual ~cScriptModule();
	cScriptModule();
	cScriptModule(const char* pszName);

	void SetName(const char* pszName);

private:
	const sScrClassDesc* GetScript(unsigned int i);
	
	char* m_pszName;

	static const sScrClassDesc sm_ScriptsArray[];
	static const unsigned int sm_ScriptsArraySize;
};
