/******************************************************************************
 *    Script.h
 *
 *    This file is part of Public Scripts
 *    Copyright (C) 2005-2007 Tom N Harris <telliamed@whoopdedo.org>
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *****************************************************************************/

#ifndef SCRIPT_H
#define SCRIPT_H

#include <lg/objstd.h>
#include <lg/script.h>
#include <lg/scrmsgs.h>

class cScript : public IScript
{
public:
	// IUnknown
	STDMETHOD(QueryInterface)(REFIID,void**);
	STDMETHOD_(ULONG,AddRef)(void);
	STDMETHOD_(ULONG,Release)(void);
	// IScript
	STDMETHOD_(const char*,GetClassName)(void);
	STDMETHOD_(long,ReceiveMessage)(sScrMsg*,sMultiParm*,eScrTraceAction);

private:
	int m_iRef;
	const char* m_szName;
	int m_iObjId;

public:
	virtual ~cScript();
	cScript(const char* pszName, int iHostObjId);

protected:
	const char* Name() { return m_szName; };
	int ObjId() { return m_iObjId; };

private:
	long ScriptPtrQuery(sPtrQueryMsg* pMsg);

};

#endif // SCRIPT_H
