/******************************************************************************
 *    CommonScripts.h
 *
 *    This file is part of Public Scripts
 *    Copyright (C) 2005-2007 Tom N Harris <telliamed@whoopdedo.org>
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *****************************************************************************/
#ifndef COMMONSCRIPTS_H
#define COMMONSCRIPTS_H

#if !SCR_GENSCRIPTS

#include "scriptvars.h"

#endif // SCR_GENSCRIPTS

/**
 * Script: BaseQVarText
 * Properties: Book\Text, Script\Use Message
 *
 * Displays text with substitutions using quest variables.
 * The string ``%{...}'' will be replaced with the value of the
 * qvar that has the name in brackets. ``%?{...}[a][b]'' will 
 * print ``a'' if the qvar is non-zero and ``b'' otherwise.
 * ``%>n{...}[a][b]'' is similar, but compares the value to 
 * the number ``n''. ``>'' can be one of ``>'',``<'',``=''.
 * Whenever a conditional substitution is made, the string
 * will be re-parsed, so you can have secondary (and tertiary...)
 * substitutions.
 */
#if !SCR_GENSCRIPTS
class cQVarText
{
public:
	cQVarText(int iHostObjId)
		: m_iObjId(iHostObjId)
	{ }

private:
	int m_iObjId;

protected:
	void Display(int iFrobber);
};
#endif // SCR_GENSCRIPTS

/**
 * Script: BaseQuestVariable
 * Properties: Trap\Quest Var, Script\QBName
 *
 * Common functions for working with quest variables.
 */
#if !SCR_GENSCRIPTS
class cQVarProcessor
{
protected:
	static int TrapProcess(bool bPositive, char cOp, int iArg, int iVal);
	static bool TrigProcess(char cOp, int iArg, int iVal, char const* pszArg);
	/**
	 * GetQVarParams
	 *
	 * Retrieve the name, operator, and argument from the Trap\QuestVar
	 * (or Script\QBName) property.
	 *
	 * Returns the entire property string (allocated by ``new char[]'').
	 */
	static char* GetQVarParams(int iObjId, char* pcOp, int* piVal, char** pszQVar);
	static int GetQVar(int iObjId, const char* pszName);
#if (_DARKGAME == 3)
	static void SetQVar(int iObjId, const char* pszName, int iVal, bool bCamp=true);
#else
	static void SetQVar(int iObjId, const char* pszName, int iVal, bool bCamp=false);
#endif
};
#endif // SCR_GENSCRIPTS

/**
 * Script: BaseRequirement
 * Links: ScriptParams("Require")
 */
#if !SCR_GENSCRIPTS
class cRequirement
{
public:
	cRequirement(int iHostObjId)
		: m_iObjId(iHostObjId)
	{ }

private:
	int m_iObjId;

protected:
	int Requirements(void);
	bool TurnOn(int iObj);
	bool TurnOff(int iObj);
};
#endif // SCR_GENSCRIPTS

/**
 * Script: BasePopulation
 * Links: Population, ScriptParams("Population")
 * Metaproperties: M-NotifyRegion
 *
 * Maintains the Population link used by OBB and Room triggers.
 */
#if !SCR_GENSCRIPTS
class cTrackPopulation
{
public:
	cTrackPopulation(int iHostObjId)
		: m_iObjId(iHostObjId)
	{ }

private:
	int m_iObjId;

protected:
	int Population(void);
	bool TrackCreatureEnter(int iObj);
	bool TrackCreatureExit(int iObj);
	bool TrackPlayerEnter(int iObj);
	bool TrackPlayerExit(int iObj);

};
#endif // SCR_GENSCRIPTS


#endif // PUBLICSCRIPTS_H
