/******************************************************************************
 *    BaseTrap.h
 *
 *    This file is part of Public Scripts
 *    Copyright (C) 2005-2007 Tom N Harris <telliamed@whoopdedo.org>
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *****************************************************************************/
#ifndef BASETRAP_H
#define BASETRAP_H

#if !SCR_GENSCRIPTS
#include "BaseScript.h"
#include <lg/defs.h>
#endif

/**
 * BaseTrap
 * 
 * Inherits: BaseScript
 */
#if !SCR_GENSCRIPTS
class cBaseTrap : public cBaseScript
{
public:
	cBaseTrap(const char* pszName, int iHostObjId)
		: cBaseScript(pszName, iHostObjId),
		  m_iTiming(0), m_iFlags(0)
	{ }

protected:
	//virtual void InitScript(void);

	virtual long OnSim(sSimMsg* pSimMsg, cMultiParm& mpReply);
	virtual long OnTurnOn(sScrMsg* pMsg, cMultiParm& mpReply);
	virtual long OnTurnOff(sScrMsg* pMsg, cMultiParm& mpReply);
	virtual long OnTimer(sScrTimerMsg* pTimerMsg, cMultiParm& mpReply);

private:
	int m_iTiming;
	unsigned long m_iFlags;

protected:
	virtual long OnSwitch(bool, sScrMsg*, cMultiParm&)
		{ return 0; }

	void InitTrapVars(void);

	int GetTiming(void)
		{ return m_iTiming; }
	void SetTiming(int t)
		{ m_iTiming = t; }
	unsigned long GetFlags(void)
		{ return m_iFlags; }
	bool GetFlag(unsigned long f)
		{ return m_iFlags & f; }
	void SetFlags(unsigned long f)
		{ m_iFlags = f; }
	void SetFlag(unsigned long f)
		{ m_iFlags |= f; }
	void UnsetFlag(unsigned long f)
		{ m_iFlags &= ~f; }

	bool IsLocked(void);
	void SetLock(bool bLock);

	void DoTrigger(bool bTurnOn, int iFrobber = 0);
	void DirectTrigger(bool bTurnOn, int iFrobber = 0);
};
#else // SCR_GENSCRIPTS
GEN_FACTORY("BaseTrap","BaseScript",cBaseTrap)
#endif // SCR_GENSCRIPTS

#endif // BASETRAP_H
